/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.LangPartial;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_3518;
import net.minecraft.class_7403;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableObject;

public class LangMerger
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String CATEGORY_HEADER = "\t\"_\": \"->------------------------]  %s  [------------------------<-\",";
    private class_2403 gen;
    private final String modid;
    private final String displayName;
    private final LangPartial[] langPartials;
    private List<Object> mergedLangData;
    private List<String> langIgnore;

    public <T extends LangPartial> LangMerger(class_2403 gen, String modid, String displayName, T[] langPartials) {
        this.gen = gen;
        this.modid = modid;
        this.displayName = displayName;
        this.langPartials = langPartials;
        this.mergedLangData = new ArrayList<Object>();
        this.langIgnore = new ArrayList<String>();
        this.populateLangIgnore();
    }

    protected void populateLangIgnore() {
        this.langIgnore.add("create.ponder.debug_");
        this.langIgnore.add("create.gui.chromatic_projector");
    }

    private boolean shouldIgnore(String key) {
        for (String string : this.langIgnore) {
            if (!key.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public String method_10321() {
        return this.displayName + "'s lang merger";
    }

    public void method_10319(class_7403 cache) throws IOException {
        Path path = this.gen.method_10313().resolve("assets/" + this.modid + "/lang/en_us.json");
        this.collectExistingEntries(path);
        this.collectEntries();
        if (this.mergedLangData.isEmpty()) {
            return;
        }
        this.save(cache, this.mergedLangData, path, "Merging en_us.json with hand-written lang entries...");
    }

    private void collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Create.LOGGER.warn("Nothing to merge! It appears no lang was generated before me.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
            HashSet keysToRemove = new HashSet();
            MutableBoolean startErasing = new MutableBoolean();
            jsonobject.entrySet().stream().forEachOrdered(entry -> {
                String key = (String)entry.getKey();
                if (key.startsWith("advancement")) {
                    startErasing.setTrue();
                }
                if (startErasing.isFalse()) {
                    return;
                }
                keysToRemove.add(key);
            });
            jsonobject.remove("_");
            keysToRemove.forEach(arg_0 -> ((JsonObject)jsonobject).remove(arg_0));
            this.addAll("Game Elements", jsonobject);
            reader.close();
        }
    }

    protected void addAll(String header, JsonObject jsonobject) {
        if (jsonobject == null) {
            return;
        }
        header = String.format(CATEGORY_HEADER, header);
        this.writeData("\n");
        this.writeData(header);
        this.writeData("\n\n");
        MutableObject previousKey = new MutableObject((Object)"");
        jsonobject.entrySet().stream().forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            if (this.shouldIgnore(key)) {
                return;
            }
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!((String)previousKey.getValue()).isEmpty() && this.shouldAddLineBreak(key, (String)previousKey.getValue())) {
                this.writeData("\n");
            }
            this.writeEntry(key, value);
            previousKey.setValue((Object)key);
        });
        this.writeData("\n");
    }

    private void writeData(String data) {
        this.mergedLangData.add(data);
    }

    private void writeEntry(String key, String value) {
        this.mergedLangData.add(new LangEntry(key, value));
    }

    protected boolean shouldAddLineBreak(String key, String previousKey) {
        if (key.endsWith(".tooltip")) {
            return true;
        }
        if (key.startsWith(this.modid + ".ponder") && key.endsWith("header")) {
            return true;
        }
        key = key.replaceFirst("\\.", "");
        previousKey = previousKey.replaceFirst("\\.", "");
        String[] split = key.split("\\.");
        String[] split2 = previousKey.split("\\.");
        if (split.length == 0 || split2.length == 0) {
            return false;
        }
        return !split[0].equals(split2[0]);
    }

    private void collectEntries() {
        for (LangPartial partial : this.langPartials) {
            this.addAll(partial.getDisplayName(), partial.provide().getAsJsonObject());
        }
    }

    private void save(class_7403 cache, List<Object> dataIn, Path target, String message) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8);
        ((Writer)writer).append(this.createString(dataIn));
        ((Writer)writer).close();
        cache.method_43346(target, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
    }

    protected String createString(List<Object> data) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        data.forEach(builder::append);
        builder.append("\t\"_\": \"Thank you for translating ").append(this.displayName).append("!\"\n\n");
        builder.append("}");
        return builder.toString();
    }

    private class LangEntry {
        static final String ENTRY_FORMAT = "\t\"%s\": %s,\n";
        private String key;
        private String value;

        LangEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format(ENTRY_FORMAT, this.key, GSON.toJson((Object)this.value, String.class));
        }
    }
}

